<?php
include 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $turma_id = $_POST['turma_id'] ?? '';
    $nome = $_POST['nome'] ?? '';

    if ($turma_id && $nome) {
        // Insere na tabela 'disciplinas'
        $stmt = $conn->prepare("INSERT INTO disciplinas (turma_id, nome) VALUES (?, ?)");
        $stmt->bind_param("is", $turma_id, $nome);
        $stmt->execute();
        echo "<script>alert('Disciplina salva com sucesso!');</script>";
    } else {
        echo "<script>alert('Preencha todos os campos.');</script>";
    }
}

// Buscar turmas, incluindo classe e curso.
$sql = "SELECT id, nome, ano, classe, curso FROM turmas ORDER BY ano DESC, nome ASC";
$turmas = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Cadastrar Disciplina</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
        }
        .top-bar {
            background: #0056b3;
            color: white;
            padding: 15px;
            font-size: 18px;
        }
        .sidebar {
            width: 220px;
            background: #1c1c1c;
            height: 100vh;
            float: left;
            padding-top: 20px;
        }
        .sidebar a {
            display: block;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
        }
        .sidebar a:hover {
            background: #333;
        }
        .content {
            margin-left: 220px;
            padding: 20px;
            background: #f4f4f4;
            min-height: 100vh;
        }
        .form-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 5px #ccc;
            max-width: 500px;
        }
        input, select {
            width: 100%;
            padding: 8px;
            margin: 6px 0;
        }
        button {
            padding: 10px 15px;
            background: #0056b3;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background: #004494;
        }
        .nav-links {
            margin-top: 15px;
        }
        .nav-links a {
            margin-right: 10px;
            color: #0056b3;
            text-decoration: none;
        }
        .nav-links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<div class="top-bar">SISMAG - Cadastrar Disciplinas</div>

<div class="sidebar">
    <a href="painel.php">🏠 Início</a>
    <a href="cadastrar_turma1.php">🏫 Cadastrar Turmas</a>
    <a href="cadastrar_aluno.php">👨‍🎓 Cadastrar Alunos</a>
    <a href="matricular_aluno.php">📋 Ver Alunos</a>
</div>

<div class="content">
    <div class="form-box">
        <h2>Nova Disciplina</h2>
        <form method="POST">
            <label>Turma:</label>
            <select name="turma_id" required>
                <option value="">-- Selecione uma turma --</option>
                <?php while ($row = $turmas->fetch_assoc()): ?>
                    <option value="<?= $row['id'] ?>">
                        <?= $row['classe'] . ' - ' . $row['nome'] . ' - ' . $row['curso'] ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <label>Nome da Disciplina:</label>
            <input name="nome" required>

            <button type="submit">Salvar</button>
        </form>

        <div class="nav-links">
            <a href="cadastrar_disciplina_anterior.php">🔁 Novo Cadastro</a>
            <a href="cadastrar_turma1.php">🔙 Voltar às Turmas</a>
        </div>
    </div>
</div>

</body>
</html>